//
//  MCDatePickerCell.h
//  PickerTester
//
//  Created by Michael Clark on 02/03/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <AppKit/AppKit.h>

// Defines for the bindings - they define indices into the various C style areas for keeping track of the necessary things
#define   MCDatePickerBindingCount       2
#define   MCDatePickerValueBinding    0x00
#define   MCDatePickerEnabledBinding  0x01
//... define more as necessary


@interface MCDatePickerCell : NSActionCell {

	
	int           _year;
	NSString*     _yearString;
	NSMenu*       _yearMenu;
	int           _yearMenuStartYear;
	int           _yearMenuEndYear;
	
	int           _month;
	NSString*     _monthString;
	NSMenu*       _monthMenu;
	
	int           _day;
	NSString*     _dayString;
	NSMenu*       _dayMenu;
	
	// Used for processing in the stop tracking method
	NSRect        _cellFrame;
	BOOL          _wasControlClick;
	
	BOOL   _drawGloss;
	BOOL   _drawText;
	
	BOOL   _mouseDown;
	int    _pressedImageIndex;
	int    _inRect; // 0 - month, 1 - day, 2 - year
	
	
	// Bindings support
	id          _observedObjects[MCDatePickerBindingCount];
	NSString*   _observedKeyPaths[MCDatePickerBindingCount];
}

// Binding support - users of class should not call these directly!!
- (void)setObservedObject: (id)observable forIndex: (int)index;
- (void)setObservedKeyPath: (NSString*)keyPath forIndex: (int)index;


- (void)toggleGloss;
- (void)toggleText;

@end
